/*
 * Decompiled with CFR 0.152.
 */
package ui.tools;

import builder.jsidblaster.JSIDBlasterBuilder;
import builder.jsidblaster.SIDType;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import sidplay.ini.IniConfig;
import sidplay.player.DebugUtil;
import ui.tools.Command;

@Parameters(resourceBundle="ui.tools.SIDBlasterTool")
public class SIDBlasterTool {
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final String PATTERN_SERIAL_NO = "[A-Z0-9]{8}";
    @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true)
    private Boolean help = Boolean.FALSE;
    @Parameter(names={"--command", "-c"}, descriptionKey="COMMAND", order=1)
    private Command command;
    @Parameter(names={"--deviceId", "-d"}, descriptionKey="DEVICE_ID", order=2)
    private int deviceId;
    @Parameter(names={"--sidType", "-t"}, descriptionKey="SID_TYPE", order=3)
    private SIDType sidType = SIDType.NONE;
    @Parameter(names={"--serial", "-s"}, descriptionKey="SERIAL", order=4)
    private String serialNo;
    private IniConfig config = new IniConfig();
    private String[] serialNumbers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute(String[] args) throws Exception {
        try {
            JCommander commander = JCommander.newBuilder().addObject((Object)this).programName(this.getClass().getName()).build();
            commander.parse(args);
            System.out.println(this.credits());
            if (this.command == null || this.help.booleanValue()) {
                commander.usage();
                this.exit(0);
            }
            this.triggerFetchSerialNumbers();
            this.serialNumbers = JSIDBlasterBuilder.getSerialNumbers();
            if (this.serialNumbers.length == 0) {
                System.out.println(RESOURCE_BUNDLE.getString("NO_SIDBLASTER_DEVICES_DETECTED"));
                JSIDBlasterBuilder.printInstallationHint();
                this.exit(1);
            }
            if (this.deviceId >= this.serialNumbers.length) {
                System.out.printf(RESOURCE_BUNDLE.getString("ILLEGAL_DEVICE_NUMBER"), this.deviceId);
                System.out.printf(RESOURCE_BUNDLE.getString("POSSIBLE_VALUE_RANGE"), this.serialNumbers.length - 1);
                this.exit(1);
            }
            switch (this.command) {
                case GET_SID_TYPE: {
                    this.printCommand("command=" + (Object)((Object)this.command), this.deviceId, JSIDBlasterBuilder.getSidType(this.deviceId));
                    return;
                }
                case SET_SID_TYPE: {
                    this.printCommand("command=" + (Object)((Object)this.command), this.deviceId, this.sidType);
                    switch (this.proceed()) {
                        case 89: 
                        case 121: {
                            System.out.printf("RC=%d\n", JSIDBlasterBuilder.setSidType(this.deviceId, this.sidType));
                            System.out.println(RESOURCE_BUNDLE.getString("DONE"));
                            return;
                        }
                    }
                    System.out.println(RESOURCE_BUNDLE.getString("ABORTED"));
                    return;
                }
                default: {
                    System.out.println(RESOURCE_BUNDLE.getString("DETECTED_SIDBLASTER_DEVICES"));
                    for (int i = 0; i < this.serialNumbers.length; ++i) {
                        this.printCommand("\t", i, JSIDBlasterBuilder.getSidType(i));
                    }
                    return;
                }
                case SET_SERIAL: {
                    if (!Pattern.matches(PATTERN_SERIAL_NO, this.serialNo)) {
                        System.out.println(RESOURCE_BUNDLE.getString("ILLEGAL_SERIAL_NUMBER"));
                        return;
                    }
                    this.printCommand("command=" + (Object)((Object)this.command), this.deviceId, JSIDBlasterBuilder.getSidType(this.deviceId));
                    System.out.printf("newSerial=%s\n", this.serialNo);
                    switch (this.proceed()) {
                        case 89: 
                        case 121: {
                            System.out.printf("RC=%d\n", JSIDBlasterBuilder.setSerial(this.deviceId, this.serialNo));
                            System.out.println(RESOURCE_BUNDLE.getString("DONE"));
                            return;
                        }
                    }
                    System.out.println(RESOURCE_BUNDLE.getString("ABORTED"));
                    return;
                }
            }
        }
        finally {
            JSIDBlasterBuilder.uninitialize();
        }
    }

    private void triggerFetchSerialNumbers() {
        new JSIDBlasterBuilder(null, this.config, null);
    }

    private String credits() {
        StringBuilder result = new StringBuilder();
        result.append(RESOURCE_BUNDLE.getString("CREDITS_PROLOG"));
        result.append(RESOURCE_BUNDLE.getString("CREDITS1"));
        result.append(RESOURCE_BUNDLE.getString("CREDITS2"));
        result.append(RESOURCE_BUNDLE.getString("CREDITS3"));
        result.append(RESOURCE_BUNDLE.getString("CREDITS4"));
        result.append(RESOURCE_BUNDLE.getString("CREDITS_EPILOG"));
        return result.toString();
    }

    private void printCommand(String prolog, int deviceId, SIDType sidType) {
        String serialNumber = this.serialNumbers[deviceId];
        System.out.printf("%s - deviceId=%d, serial=%s, type=%s\n", new Object[]{prolog, deviceId, serialNumber, sidType});
    }

    private int proceed() throws IOException {
        System.out.println(RESOURCE_BUNDLE.getString("ARE_YOU_SURE"));
        return System.in.read();
    }

    private void exit(int rc) throws IOException {
        System.out.println(RESOURCE_BUNDLE.getString("EXIT"));
        System.in.read();
        System.exit(rc);
    }

    public static void main(String[] args) throws Exception {
        new SIDBlasterTool().execute(args);
    }

    static {
        DebugUtil.init();
        RESOURCE_BUNDLE = ResourceBundle.getBundle("ui.tools.SIDBlasterTool");
    }
}

